/* TH58DVG4S0ETA20.h */
#ifndef TH58DVG4S0ETA20_H
#define TH58DVG4S0ETA20_H

#define MTD_NAND_MN2WS_PAGE_SIZE_MASK	0x03
/* TOSHIBA does not have oob size */
#define MTD_NAND_MN2WS_BLOCK_SIZE_MASK	0x30
/* TOSHIBA does not have width size */

#define MTD_NAND_MN2WS_PAGE_SIZE_SHIFT	0x00
/* TOSHIBA does not have oob size */
#define MTD_NAND_MN2WS_BLOCK_SIZE_SHIFT	0x04
/* TOSHIBA does not have width size */

#define MTD_NAND_MN2WS_PAGE_SIZE_BASE	1024
/* TOSHIBA does not have oob size */
#define MTD_NAND_MN2WS_BLOCK_SIZE_BASE	(64 * 1024)
/* TOSHIBA does not have width size */

#define MTD_NAND_MN2WS_ID_READ_NUM	5

static inline uint32_t nand_gpbc_get_writesize(u8 id_data)
{
	int bits = (id_data & MTD_NAND_MN2WS_PAGE_SIZE_MASK) >>
		MTD_NAND_MN2WS_PAGE_SIZE_SHIFT;
	return MTD_NAND_MN2WS_PAGE_SIZE_BASE << bits;
}

static inline uint32_t nand_gpbc_get_oobsize(u8 id_data)
{
	return 128;
}

static inline uint32_t nand_gpbc_get_erasesize(u8 id_data)
{
	int bits = (id_data & MTD_NAND_MN2WS_BLOCK_SIZE_MASK) >>
		MTD_NAND_MN2WS_BLOCK_SIZE_SHIFT;
	return MTD_NAND_MN2WS_BLOCK_SIZE_BASE << bits;
}

static inline uint32_t nand_gpbc_get_width(u8 id_data)
{
	return 8;
}

#endif /* TH58DVG4S0ETA20_H */
